package googleapis.bigquery

import io.circe._

sealed abstract class DatasetAccessEntryTargetType(val value: String)
    extends Product
    with Serializable
object DatasetAccessEntryTargetType {
  // Do not use. You must set a target type explicitly.
  case object TARGET_TYPE_UNSPECIFIED
      extends DatasetAccessEntryTargetType("TARGET_TYPE_UNSPECIFIED")
  // This entry applies to views in the dataset.
  case object VIEWS extends DatasetAccessEntryTargetType("VIEWS")
  // This entry applies to routines in the dataset.
  case object ROUTINES extends DatasetAccessEntryTargetType("ROUTINES")
  val values = List(TARGET_TYPE_UNSPECIFIED, VIEWS, ROUTINES)
  def fromString(input: String): Either[String, DatasetAccessEntryTargetType] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for DatasetAccessEntryTargetType")
  implicit val decoder: Decoder[DatasetAccessEntryTargetType] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[DatasetAccessEntryTargetType] = Encoder[String].contramap(_.value)
}
