package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DatasetAccessEntry(
    // [Required] The dataset this entry applies to.
    dataset: DatasetReference,
    targetTypes: Option[
      List[DatasetAccessEntryTargetType]
    ] = None,
)
object DatasetAccessEntry {
  implicit val encoder: Encoder[DatasetAccessEntry] = Encoder.instance { x =>
    Json.obj("dataset" := x.dataset, "targetTypes" := x.targetTypes)
  }
  implicit val decoder: Decoder[DatasetAccessEntry] = Decoder.instance { c =>
    for {
      v0 <- c.get[DatasetReference]("dataset")
      v1 <- c.get[Option[List[DatasetAccessEntryTargetType]]]("targetTypes")
    } yield DatasetAccessEntry(v0, v1)

  }
}
