package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DatasetAccess(
    // [Pick one] A routine from a different dataset to grant access to. Queries executed against that routine will have read access to views/tables/routines in this dataset. Only UDF is supported for now. The role field is not required when this field is set. If that routine is updated by any user, access to the routine needs to be granted again via an update operation.
    routine: Option[RoutineReference] = None,
    // [Required] An IAM role ID that should be granted to the user, group, or domain specified in this access entry. The following legacy mappings will be applied: OWNER  roles/bigquery.dataOwner WRITER  roles/bigquery.dataEditor READER  roles/bigquery.dataViewer This field will accept any of the above formats, but will return only the legacy format. For example, if you set this field to "roles/bigquery.dataOwner", it will be returned back as "OWNER".
    role: String,
    // [Pick one] A special group to grant access to. Possible values include: projectOwners: Owners of the enclosing project. projectReaders: Readers of the enclosing project. projectWriters: Writers of the enclosing project. allAuthenticatedUsers: All authenticated BigQuery users. Maps to similarly-named IAM members.
    specialGroup: Option[String] = None,
    // [Pick one] A domain to grant access to. Any users signed in with the domain specified will be granted the specified access. Example: "example.com". Maps to IAM policy member "domain:DOMAIN".
    domain: Option[String] = None,
    // [Pick one] An email address of a user to grant access to. For example: fred@example.com. Maps to IAM policy member "user:EMAIL" or "serviceAccount:EMAIL".
    userByEmail: Option[String] = None,
    // [Pick one] A grant authorizing all resources of a particular type in a particular dataset access to this dataset. Only views are supported for now. The role field is not required when this field is set. If that dataset is deleted and re-created, its access needs to be granted again via an update operation.
    dataset: Option[DatasetAccessEntry] = None,
    // [Pick one] An email address of a Google Group to grant access to. Maps to IAM policy member "group:GROUP".
    groupByEmail: Option[String] = None,
    // [Pick one] Some other type of member that appears in the IAM Policy but isn't a user, group, domain, or special group.
    iamMember: Option[String] = None,
    // [Pick one] A view from a different dataset to grant access to. Queries executed against that view will have read access to tables in this dataset. The role field is not required when this field is set. If that view is updated by any user, access to the view needs to be granted again via an update operation.
    view: Option[TableReference] = None,
)
object DatasetAccess {
  implicit val encoder: Encoder[DatasetAccess] = Encoder.instance { x =>
    Json.obj(
      "routine" := x.routine,
      "role" := x.role,
      "specialGroup" := x.specialGroup,
      "domain" := x.domain,
      "userByEmail" := x.userByEmail,
      "dataset" := x.dataset,
      "groupByEmail" := x.groupByEmail,
      "iamMember" := x.iamMember,
      "view" := x.view,
    )
  }
  implicit val decoder: Decoder[DatasetAccess] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[RoutineReference]]("routine")
      v1 <- c.get[String]("role")
      v2 <- c.get[Option[String]]("specialGroup")
      v3 <- c.get[Option[String]]("domain")
      v4 <- c.get[Option[String]]("userByEmail")
      v5 <- c.get[Option[DatasetAccessEntry]]("dataset")
      v6 <- c.get[Option[String]]("groupByEmail")
      v7 <- c.get[Option[String]]("iamMember")
      v8 <- c.get[Option[TableReference]]("view")
    } yield DatasetAccess(v0, v1, v2, v3, v4, v5, v6, v7, v8)
  }
}
