package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class Dataset( // [Output-only] A hash of the resource.
    etag: Option[String] =
      None, // [Output-only] The date when this dataset or any of its tables was last modified, in milliseconds since the epoch.
    lastModifiedTime: Option[FiniteDuration] =
      None, // [Required] A reference that identifies the dataset.
    datasetReference: DatasetReference, // The geographic location where the dataset should reside. The default value is US. See details at https://cloud.google.com/bigquery/docs/locations.
    location: Option[String] = None,
    defaultEncryptionConfiguration: Option[EncryptionConfiguration] =
      None, // [Output-only] Reserved for future use.
    satisfiesPzs: Option[Boolean] =
      None, // [Optional] Storage billing model to be used for all tables in the dataset. Can be set to PHYSICAL. Default is LOGICAL.
    storageBillingModel: Option[String] =
      None, // [Optional] A user-friendly description of the dataset.
    description: Option[String] =
      None, // [Optional]The tags associated with this dataset. Tag keys are globally unique.
    tags: Option[List[DatasetTag]] = None, // [Optional] A descriptive name for the dataset.
    friendlyName: Option[String] =
      None, // [Optional] The default partition expiration for all partitioned tables in the dataset, in milliseconds. Once this property is set, all newly-created partitioned tables in the dataset will have an expirationMs property in the timePartitioning settings set to this value, and changing the value will only affect new tables, not existing ones. The storage in a partition will have an expiration time of its partition time plus this value. Setting this property overrides the use of defaultTableExpirationMs for partitioned tables: only one of defaultTableExpirationMs and defaultPartitionExpirationMs will be used for any new partitioned table. If you provide an explicit timePartitioning.expirationMs when creating or updating a partitioned table, that value takes precedence over the default partition expiration time indicated by this property.
    defaultPartitionExpirationMs: Option[FiniteDuration] =
      None, // [Output-only] A URL that can be used to access the resource again. You can use this URL in Get or Update requests to the resource.
    selfLink: Option[String] =
      None, // [Optional] Number of hours for the max time travel for all tables in the dataset.
    maxTimeTravelHours: Option[Long] =
      None, // [Optional] The default lifetime of all tables in the dataset, in milliseconds. The minimum value is 3600000 milliseconds (one hour). Once this property is set, all newly-created tables in the dataset will have an expirationTime property set to the creation time plus the value in this property, and changing the value will only affect new tables, not existing ones. When the expirationTime for a given table is reached, that table will be deleted automatically. If a table's expirationTime is modified or removed before the table expires, or if you provide an explicit expirationTime when creating a table, that value takes precedence over the default expiration time indicated by this property.
    defaultTableExpirationMs: Option[FiniteDuration] =
      None, // [Output-only] The fully-qualified unique name of the dataset in the format projectId:datasetId. The dataset name without the project name is given in the datasetId field. When creating a new dataset, leave this field blank, and instead specify the datasetId field.
    id: Option[String] =
      None, // The labels associated with this dataset. You can use these to organize and group your datasets. You can set this property when inserting or updating a dataset. See Creating and Updating Dataset Labels for more information.
    labels: Option[Map[String, String]] =
      None, // [Output-only] The default rounding mode of the dataset.
    defaultRoundingMode: Option[String] =
      None, // [Optional] Information about the external metadata storage where the dataset is defined. Filled out when the dataset type is EXTERNAL.
    externalDatasetReference: Option[ExternalDatasetReference] =
      None, // [Output-only] The default collation of the dataset.
    defaultCollation: Option[String] = None, // [Output-only] The resource type.
    kind: Option[String] =
      None, // [Optional] Indicates if table names are case insensitive in the dataset.
    isCaseInsensitive: Option[Boolean] =
      None, // [Output-only] The time when this dataset was created, in milliseconds since the epoch.
    creationTime: Option[FiniteDuration] =
      None, // [Optional] An array of objects that define dataset access for one or more entities. You can set this property when inserting or updating a dataset in order to control who is allowed to access the data. If unspecified at dataset creation time, BigQuery adds default dataset access for the following entities: access.specialGroup: projectReaders; access.role: READER; access.specialGroup: projectWriters; access.role: WRITER; access.specialGroup: projectOwners; access.role: OWNER; access.userByEmail: [dataset creator email]; access.role: OWNER;
    access: Option[List[DatasetAccess]] = None,
)
object Dataset {
  implicit val encoder: Encoder[Dataset] = Encoder.instance { x =>
    Json.obj(
      "etag" := x.etag,
      "lastModifiedTime" := x.lastModifiedTime,
      "datasetReference" := x.datasetReference,
      "location" := x.location,
      "defaultEncryptionConfiguration" := x.defaultEncryptionConfiguration,
      "satisfiesPzs" := x.satisfiesPzs,
      "storageBillingModel" := x.storageBillingModel,
      "description" := x.description,
      "tags" := x.tags,
      "friendlyName" := x.friendlyName,
      "defaultPartitionExpirationMs" := x.defaultPartitionExpirationMs,
      "selfLink" := x.selfLink,
      "maxTimeTravelHours" := x.maxTimeTravelHours,
      "defaultTableExpirationMs"
        := x.defaultTableExpirationMs,
      "id" := x.id,
      "labels" := x.labels,
      "defaultRoundingMode" := x.defaultRoundingMode,
      "externalDatasetReference"
        := x.externalDatasetReference,
      "defaultCollation" := x.defaultCollation,
      "kind" := x.kind,
      "isCaseInsensitive" := x.isCaseInsensitive,
      "creationTime" := x.creationTime,
      "access" := x.access,
    )
  }
  implicit val decoder: Decoder[Dataset] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[FiniteDuration]]("lastModifiedTime")
      v2 <- c.get[DatasetReference]("datasetReference")
      v3 <- c.get[Option[String]]("location")
      v4 <- c.get[Option[EncryptionConfiguration]]("defaultEncryptionConfiguration")
      v5 <- c.get[Option[Boolean]]("satisfiesPzs")
      v6 <- c.get[Option[String]]("storageBillingModel")
      v7 <- c.get[Option[String]]("description")
      v8 <- c.get[Option[List[DatasetTag]]]("tags")
      v9 <- c.get[Option[String]]("friendlyName")
      v10 <- c.get[Option[FiniteDuration]]("defaultPartitionExpirationMs")
      v11 <- c.get[Option[String]]("selfLink")
      v12 <- c.get[Option[Long]]("maxTimeTravelHours")
      v13 <- c.get[Option[FiniteDuration]]("defaultTableExpirationMs")
      v14 <- c.get[Option[String]]("id")
      v15 <- c.get[Option[Map[String, String]]]("labels")
      v16 <- c.get[Option[String]]("defaultRoundingMode")
      v17 <- c.get[Option[ExternalDatasetReference]]("externalDatasetReference")
      v18 <- c.get[Option[String]]("defaultCollation")
      v19 <- c.get[Option[String]]("kind")
      v20 <- c.get[Option[Boolean]]("isCaseInsensitive")
      v21 <- c.get[Option[FiniteDuration]]("creationTime")
      v22 <- c.get[Option[List[DatasetAccess]]]("access")
    } yield Dataset(
      v0,
      v1,
      v2,
      v3,
      v4,
      v5,
      v6,
      v7,
      v8,
      v9,
      v10,
      v11,
      v12,
      v13,
      v14,
      v15,
      v16,
      v17,
      v18,
      v19,
      v20,
      v21,
      v22,
    )
  }
}
