package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DataSplitResult(
    // Table reference of the evaluation data after split.
    evaluationTable: Option[TableReference] = None,
    // Table reference of the test data after split.
    testTable: Option[TableReference] = None,
    // Table reference of the training data after split.
    trainingTable: Option[TableReference] = None,
)
object DataSplitResult {
  implicit val encoder: Encoder[DataSplitResult] = Encoder.instance { x =>
    Json.obj(
      "evaluationTable" := x.evaluationTable,
      "testTable" := x.testTable,
      "trainingTable" := x.trainingTable,
    )
  }
  implicit val decoder: Decoder[DataSplitResult] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[TableReference]]("evaluationTable")
      v1 <- c.get[Option[TableReference]]("testTable")
      v2 <- c.get[Option[TableReference]]("trainingTable")
    } yield DataSplitResult(v0, v1, v2)
  }
}
