package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class DataMaskingStatistics(
    // [Output-only] [Preview] Whether any accessed data was protected by data masking. The actual evaluation is done by accessStats.masked_field_count > 0. Since this is only used for the discovery_doc generation purpose, as long as the type (boolean) matches, client library can leverage this. The actual evaluation of the variable is done else-where.
    dataMaskingApplied: Option[Boolean] = None
)
object DataMaskingStatistics {
  implicit val encoder: Encoder[DataMaskingStatistics] = Encoder.instance { x =>
    Json.obj("dataMaskingApplied" := x.dataMaskingApplied)
  }
  implicit val decoder: Decoder[DataMaskingStatistics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Boolean]]("dataMaskingApplied")
    } yield DataMaskingStatistics(v0)

  }
}
