package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class CsvOptions(
    // [Optional] Preserves the embedded ASCII control characters (the first 32 characters in the ASCII-table, from '\x00' to '\x1F') when loading from CSV. Only applicable to CSV, ignored for other formats.
    preserveAsciiControlCharacters: Option[Boolean] = None,
    // [Optional] The separator for fields in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. BigQuery also supports the escape sequence "\t" to specify a tab separator. The default value is a comma (',').
    fieldDelimiter: Option[String] = None,
    // [Optional] The number of rows at the top of a CSV file that BigQuery will skip when reading the data. The default value is 0. This property is useful if you have header rows in the file that should be skipped. When autodetect is on, the behavior is the following: * skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected, the row is read as data. Otherwise data is read starting from the second row. * skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected, row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
    skipLeadingRows: Option[Long] = None,
    // [Optional] The character encoding of the data. The supported values are UTF-8 or ISO-8859-1. The default value is UTF-8. BigQuery decodes the data after the raw, binary data has been split using the values of the quote and fieldDelimiter properties.
    encoding: Option[String] = None,
    // [Optional] Indicates if BigQuery should accept rows that are missing trailing optional columns. If true, BigQuery treats missing trailing columns as null values. If false, records with missing trailing columns are treated as bad records, and if there are too many bad records, an invalid error is returned in the job result. The default value is false.
    allowJaggedRows: Option[Boolean] = None,
    // [Optional] The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the first byte of the encoded string to split the data in its raw, binary state. The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string. If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
    quote: Option[String] = None,
    // [Optional] Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file. The default value is false.
    allowQuotedNewlines: Option[Boolean] = None,
    // [Optional] An custom string that will represent a NULL value in CSV import data.
    nullMarker: Option[String] = None,
)
object CsvOptions {
  implicit val encoder: Encoder[CsvOptions] = Encoder.instance { x =>
    Json.obj(
      "preserveAsciiControlCharacters" := x.preserveAsciiControlCharacters,
      "fieldDelimiter" := x.fieldDelimiter,
      "skipLeadingRows" := x.skipLeadingRows,
      "encoding" := x.encoding,
      "allowJaggedRows" := x.allowJaggedRows,
      "quote" := x.quote,
      "allowQuotedNewlines" := x.allowQuotedNewlines,
      "nullMarker" := x.nullMarker,
    )
  }
  implicit val decoder: Decoder[CsvOptions] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Boolean]]("preserveAsciiControlCharacters")
      v1 <- c.get[Option[String]]("fieldDelimiter")
      v2 <- c.get[Option[Long]]("skipLeadingRows")
      v3 <- c.get[Option[String]]("encoding")
      v4 <- c.get[Option[Boolean]]("allowJaggedRows")
      v5 <- c.get[Option[String]]("quote")
      v6 <- c.get[Option[Boolean]]("allowQuotedNewlines")
      v7 <- c.get[Option[String]]("nullMarker")
    } yield CsvOptions(v0, v1, v2, v3, v4, v5, v6, v7)
  }
}
