package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ConnectionProperty(
    // [Required] Name of the connection property to set.
    key: String, // [Required] Value of the connection property.
    value: String,
)
object ConnectionProperty {
  implicit val encoder: Encoder[ConnectionProperty] = Encoder.instance { x =>
    Json.obj("key" := x.key, "value" := x.value)
  }
  implicit val decoder: Decoder[ConnectionProperty] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("key")
      v1 <- c.get[String]("value")
    } yield ConnectionProperty(v0, v1)

  }
}
