package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ConfusionMatrix(
    // Confidence threshold used when computing the entries of the confusion matrix.
    confidenceThreshold: Option[Double] = None, // One row per actual label.
    rows: Option[List[Row]] = None,
)
object ConfusionMatrix {
  implicit val encoder: Encoder[ConfusionMatrix] = Encoder.instance { x =>
    Json.obj("confidenceThreshold" := x.confidenceThreshold, "rows" := x.rows)
  }
  implicit val decoder: Decoder[ConfusionMatrix] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Double]]("confidenceThreshold")
      v1 <- c.get[Option[List[Row]]]("rows")
    } yield ConfusionMatrix(v0, v1)
  }
}
