package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ClusteringMetrics( // Information for all clusters.
    clusters: Option[List[Cluster]] = None, // Davies-Bouldin index.
    daviesBouldinIndex: Option[Double] =
      None, // Mean of squared distances between each sample to its cluster centroid.
    meanSquaredDistance: Option[Double] = None,
)
object ClusteringMetrics {
  implicit val encoder: Encoder[ClusteringMetrics] = Encoder.instance { x =>
    Json.obj(
      "clusters" := x.clusters,
      "daviesBouldinIndex" := x.daviesBouldinIndex,
      "meanSquaredDistance" := x.meanSquaredDistance,
    )
  }
  implicit val decoder: Decoder[ClusteringMetrics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[Cluster]]]("clusters")
      v1 <- c.get[Option[Double]]("daviesBouldinIndex")
      v2 <- c.get[Option[Double]]("meanSquaredDistance")
    } yield ClusteringMetrics(v0, v1, v2)

  }
}
