package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class Clustering(
    // [Repeated] One or more fields on which data should be clustered. Only top-level, non-repeated, simple-type fields are supported. When you cluster a table using multiple columns, the order of columns you specify is important. The order of the specified columns determines the sort order of the data.
    fields: Option[List[String]] = None
)
object Clustering {
  implicit val encoder: Encoder[Clustering] = Encoder.instance { x =>
    Json.obj("fields" := x.fields)
  }
  implicit val decoder: Decoder[Clustering] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("fields")
    } yield Clustering(v0)
  }
}
