package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ClusterInfo( // Centroid id.
    centroidId: Option[Long] =
      None, // Cluster radius, the average distance from centroid to each point assigned to the cluster.
    clusterRadius: Option[Double] =
      None, // Cluster size, the total number of points assigned to the cluster.
    clusterSize: Option[Long] = None,
)
object ClusterInfo {
  implicit val encoder: Encoder[ClusterInfo] = Encoder.instance { x =>
    Json.obj(
      "centroidId" := x.centroidId,
      "clusterRadius" := x.clusterRadius,
      "clusterSize" := x.clusterSize,
    )
  }
  implicit val decoder: Decoder[ClusterInfo] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Long]]("centroidId")
      v1 <- c.get[Option[Double]]("clusterRadius")
      v2 <- c.get[Option[Long]]("clusterSize")
    } yield ClusterInfo(v0, v1, v2)
  }
}
