package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class Cluster( // Centroid id.
    centroidId: Option[Long] =
      None, // Count of training data rows that were assigned to this cluster.
    count: Option[Long] = None, // Values of highly variant features for this cluster.
    featureValues: Option[List[FeatureValue]] = None,
)
object Cluster {
  implicit val encoder: Encoder[Cluster] = Encoder.instance { x =>
    Json.obj(
      "centroidId" := x.centroidId,
      "count" := x.count,
      "featureValues" := x.featureValues,
    )
  }
  implicit val decoder: Decoder[Cluster] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Long]]("centroidId")
      v1 <- c.get[Option[Long]]("count")
      v2 <- c.get[Option[List[FeatureValue]]]("featureValues")
    } yield Cluster(v0, v1, v2)
  }
}
