package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class CloneDefinition(
    // [Required] Reference describing the ID of the table that was cloned.
    baseTableReference: TableReference,
    // [Required] The time at which the base table was cloned. This value is reported in the JSON response using RFC3339 format.
    cloneTime: String,
)
object CloneDefinition {
  implicit val encoder: Encoder[CloneDefinition] = Encoder.instance { x =>
    Json.obj(
      "baseTableReference" := x.baseTableReference,
      "cloneTime" := x.cloneTime,
    )
  }
  implicit val decoder: Decoder[CloneDefinition] = Decoder.instance { c =>
    for {
      v0 <- c.get[TableReference]("baseTableReference")
      v1 <- c.get[String]("cloneTime")
    } yield CloneDefinition(v0, v1)
  }
}
