package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class CategoryCount( // The name of category.
    category: Option[String] =
      None, // The count of training samples matching the category within the cluster.
    count: Option[Long] = None,
)
object CategoryCount {
  implicit val encoder: Encoder[CategoryCount] = Encoder.instance { x =>
    Json.obj("category" := x.category, "count" := x.count)
  }
  implicit val decoder: Decoder[CategoryCount] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("category")
      v1 <- c.get[Option[Long]]("count")
    } yield CategoryCount(v0, v1)
  }
}
