package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class CategoricalValue(
    // Counts of all categories for the categorical feature. If there are more than ten categories, we return top ten (by count) and return one more CategoryCount with category "_OTHER_" and count as aggregate counts of remaining categories.
    categoryCounts: Option[List[CategoryCount]] = None
)
object CategoricalValue {
  implicit val encoder: Encoder[CategoricalValue] = Encoder.instance { x =>
    Json.obj("categoryCounts" := x.categoryCounts)
  }
  implicit val decoder: Decoder[CategoricalValue] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[CategoryCount]]]("categoryCounts")
    } yield CategoricalValue(v0)
  }
}
