package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class BqmlTrainingRunTrainingOptions(
    l1Reg: Option[Double] = None,
    warmStart: Option[Boolean] = None,
    maxIteration: Option[Long] = None,
    learnRateStrategy: Option[String] = None,
    learnRate: Option[Double] = None,
    earlyStop: Option[Boolean] = None,
    l2Reg: Option[Double] = None,
    minRelProgress: Option[Double] = None,
    lineSearchInitLearnRate: Option[Double] = None,
)
object BqmlTrainingRunTrainingOptions {
  implicit val encoder: Encoder[
    BqmlTrainingRunTrainingOptions
  ] = Encoder.instance { x =>
    Json.obj(
      "l1Reg" := x.l1Reg,
      "warmStart" := x.warmStart,
      "maxIteration" := x.maxIteration,
      "learnRateStrategy" := x.learnRateStrategy,
      "learnRate" := x.learnRate,
      "earlyStop" := x.earlyStop,
      "l2Reg" := x.l2Reg,
      "minRelProgress" := x.minRelProgress,
      "lineSearchInitLearnRate" := x.lineSearchInitLearnRate,
    )
  }
  implicit val decoder: Decoder[
    BqmlTrainingRunTrainingOptions
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Double]]("l1Reg")
      v1 <- c.get[Option[Boolean]]("warmStart")
      v2 <- c.get[Option[Long]]("maxIteration")
      v3 <- c.get[Option[String]]("learnRateStrategy")
      v4 <- c.get[Option[Double]]("learnRate")
      v5 <- c.get[Option[Boolean]]("earlyStop")
      v6 <- c.get[Option[Double]]("l2Reg")
      v7 <- c.get[Option[Double]]("minRelProgress")
      v8 <- c.get[Option[Double]]("lineSearchInitLearnRate")
    } yield BqmlTrainingRunTrainingOptions(v0, v1, v2, v3, v4, v5, v6, v7, v8)
  }
}
