package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class BqmlTrainingRun(
    // [Output-only, Beta] List of each iteration results.
    iterationResults: Option[List[BqmlIterationResult]] = None,
    // [Output-only, Beta] Training run start time in milliseconds since the epoch.
    startTime: Option[String] = None,
    // [Output-only, Beta] Different state applicable for a training run. IN PROGRESS: Training run is in progress. FAILED: Training run ended due to a non-retryable failure. SUCCEEDED: Training run successfully completed. CANCELLED: Training run cancelled by the user.
    state: Option[String] = None,
    // [Output-only, Beta] Training options used by this training run. These options are mutable for subsequent training runs. Default values are explicitly stored for options not specified in the input query of the first training run. For subsequent training runs, any option not explicitly specified in the input query will be copied from the previous training run.
    trainingOptions: Option[BqmlTrainingRunTrainingOptions] = None,
)
object BqmlTrainingRun {
  implicit val encoder: Encoder[BqmlTrainingRun] = Encoder.instance { x =>
    Json.obj(
      "iterationResults" := x.iterationResults,
      "startTime" := x.startTime,
      "state" := x.state,
      "trainingOptions" := x.trainingOptions,
    )
  }
  implicit val decoder: Decoder[BqmlTrainingRun] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[BqmlIterationResult]]]("iterationResults")
      v1 <- c.get[Option[String]]("startTime")
      v2 <- c.get[Option[String]]("state")
      v3 <- c.get[Option[BqmlTrainingRunTrainingOptions]]("trainingOptions")
    } yield BqmlTrainingRun(v0, v1, v2, v3)
  }
}
