package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class BqmlIterationResult(
    // [Output-only, Beta] Training loss computed on the training data at the end of the iteration. The training loss function is defined by model type.
    trainingLoss: Option[Double] = None,
    // [Output-only, Beta] Learning rate used for this iteration, it varies for different training iterations if learn_rate_strategy option is not constant.
    learnRate: Option[Double] = None,
    // [Output-only, Beta] Time taken to run the training iteration in milliseconds.
    durationMs: Option[FiniteDuration] = None,
    // [Output-only, Beta] Index of the ML training iteration, starting from zero for each training run.
    index: Option[Int] = None,
    // [Output-only, Beta] Eval loss computed on the eval data at the end of the iteration. The eval loss is used for early stopping to avoid overfitting. No eval loss if eval_split_method option is specified as no_split or auto_split with input data size less than 500 rows.
    evalLoss: Option[Double] = None,
)
object BqmlIterationResult {
  implicit val encoder: Encoder[BqmlIterationResult] = Encoder.instance { x =>
    Json.obj(
      "trainingLoss" := x.trainingLoss,
      "learnRate" := x.learnRate,
      "durationMs"
        := x.durationMs,
      "index" := x.index,
      "evalLoss" := x.evalLoss,
    )
  }
  implicit val decoder: Decoder[BqmlIterationResult] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Double]]("trainingLoss")
      v1 <- c.get[Option[Double]]("learnRate")
      v2 <- c.get[Option[FiniteDuration]]("durationMs")
      v3 <- c.get[Option[Int]]("index")
      v4 <- c.get[Option[Double]]("evalLoss")
    } yield BqmlIterationResult(v0, v1, v2, v3, v4)

  }
}
