package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class BinaryConfusionMatrix(
    // Number of true samples predicted as false.
    trueNegatives: Option[Long] = None,
    // The fraction of actual positive predictions that had positive actual labels.
    precision: Option[Double] = None,
    // The equally weighted average of recall and precision.
    f1Score: Option[Double] = None,
    // Threshold value used when computing each of the following metric.
    positiveClassThreshold: Option[Double] = None,
    // The fraction of predictions given the correct label.
    accuracy: Option[Double] = None, // Number of false samples predicted as true.
    falsePositives: Option[Long] = None,
    // Number of false samples predicted as false.
    falseNegatives: Option[Long] = None,
    // Number of true samples predicted as true.
    truePositives: Option[Long] = None,
    // The fraction of actual positive labels that were given a positive prediction.
    recall: Option[Double] = None,
)
object BinaryConfusionMatrix {
  implicit val encoder: Encoder[BinaryConfusionMatrix] = Encoder.instance { x =>
    Json.obj(
      "trueNegatives" := x.trueNegatives,
      "precision" := x.precision,
      "f1Score"
        := x.f1Score,
      "positiveClassThreshold" := x.positiveClassThreshold,
      "accuracy" := x.accuracy,
      "falsePositives" := x.falsePositives,
      "falseNegatives" := x.falseNegatives,
      "truePositives" := x.truePositives,
      "recall" := x.recall,
    )
  }
  implicit val decoder: Decoder[BinaryConfusionMatrix] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Long]]("trueNegatives")
      v1 <- c.get[Option[Double]]("precision")
      v2 <- c.get[Option[Double]]("f1Score")
      v3 <- c.get[Option[Double]]("positiveClassThreshold")
      v4 <- c.get[Option[Double]]("accuracy")
      v5 <- c.get[Option[Long]]("falsePositives")
      v6 <- c.get[Option[Long]]("falseNegatives")
      v7 <- c.get[Option[Long]]("truePositives")
      v8 <- c.get[Option[Double]]("recall")
    } yield BinaryConfusionMatrix(v0, v1, v2, v3, v4, v5, v6, v7, v8)

  }
}
