package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class BinaryClassificationMetrics(
    // Aggregate classification metrics.
    aggregateClassificationMetrics: Option[AggregateClassificationMetrics] = None,
    // Binary confusion matrix at multiple thresholds.
    binaryConfusionMatrixList: Option[List[BinaryConfusionMatrix]] = None,
    // Label representing the negative class.
    negativeLabel: Option[String] = None,
    // Label representing the positive class.
    positiveLabel: Option[String] = None,
)
object BinaryClassificationMetrics {
  implicit val encoder: Encoder[
    BinaryClassificationMetrics
  ] = Encoder.instance { x =>
    Json.obj(
      "aggregateClassificationMetrics" := x.aggregateClassificationMetrics,
      "binaryConfusionMatrixList" := x.binaryConfusionMatrixList,
      "negativeLabel" := x.negativeLabel,
      "positiveLabel" := x.positiveLabel,
    )
  }
  implicit val decoder: Decoder[
    BinaryClassificationMetrics
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[AggregateClassificationMetrics]]("aggregateClassificationMetrics")
      v1 <- c.get[Option[List[BinaryConfusionMatrix]]]("binaryConfusionMatrixList")
      v2 <- c.get[Option[String]]("negativeLabel")
      v3 <- c.get[Option[String]]("positiveLabel")
    } yield BinaryClassificationMetrics(v0, v1, v2, v3)
  }
}
