package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class BigtableOptions(
    // [Optional] List of column families to expose in the table schema along with their types. This list restricts the column families that can be referenced in queries and specifies their value types. You can use this list to do type conversions - see the 'type' field for more details. If you leave this list empty, all column families are present in the table schema and their values are read as BYTES. During a query only the column families referenced in that query are read from Bigtable.
    columnFamilies: Option[List[BigtableColumnFamily]] = None,
    // [Optional] If field is true, then the column families that are not specified in columnFamilies list are not exposed in the table schema. Otherwise, they are read with BYTES type values. The default value is false.
    ignoreUnspecifiedColumnFamilies: Option[Boolean] = None,
    // [Optional] If field is true, then the rowkey column families will be read and converted to string. Otherwise they are read with BYTES type values and users need to manually cast them with CAST if necessary. The default value is false.
    readRowkeyAsString: Option[Boolean] = None,
)
object BigtableOptions {
  implicit val encoder: Encoder[BigtableOptions] = Encoder.instance { x =>
    Json.obj(
      "columnFamilies" := x.columnFamilies,
      "ignoreUnspecifiedColumnFamilies" :=
        x.ignoreUnspecifiedColumnFamilies,
      "readRowkeyAsString" := x.readRowkeyAsString,
    )
  }
  implicit val decoder: Decoder[BigtableOptions] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[BigtableColumnFamily]]]("columnFamilies")
      v1 <- c.get[Option[Boolean]]("ignoreUnspecifiedColumnFamilies")
      v2 <- c.get[Option[Boolean]]("readRowkeyAsString")
    } yield BigtableOptions(v0, v1, v2)
  }
}
