package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class BigtableColumnFamily(
    // [Optional] If this is set only the latest version of value are exposed for all columns in this column family. This can be overridden for a specific column by listing that column in 'columns' and specifying a different setting for that column.
    onlyReadLatest: Option[Boolean] = None,
    // [Optional] The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. This can be overridden for a specific column by listing that column in 'columns' and specifying an encoding for it.
    encoding: Option[String] = None,
    // [Optional] Lists of columns that should be exposed as individual fields as opposed to a list of (column name, value) pairs. All columns whose qualifier matches a qualifier in this list can be accessed as .. Other columns can be accessed as a list through .Column field.
    columns: Option[List[BigtableColumn]] = None,
    // Identifier of the column family.
    familyId: Option[String] = None,
    // [Optional] The type to convert the value in cells of this column family. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN Default type is BYTES. This can be overridden for a specific column by listing that column in 'columns' and specifying a type for it.
    `type`: Option[String] = None,
)
object BigtableColumnFamily {
  implicit val encoder: Encoder[BigtableColumnFamily] = Encoder.instance { x =>
    Json.obj(
      "onlyReadLatest" := x.onlyReadLatest,
      "encoding" := x.encoding,
      "columns"
        := x.columns,
      "familyId" := x.familyId,
      "type" := x.`type`,
    )
  }
  implicit val decoder: Decoder[BigtableColumnFamily] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Boolean]]("onlyReadLatest")
      v1 <- c.get[Option[String]]("encoding")
      v2 <- c.get[Option[List[BigtableColumn]]]("columns")
      v3 <- c.get[Option[String]]("familyId")
      v4 <- c.get[Option[String]]("type")
    } yield BigtableColumnFamily(v0, v1, v2, v3, v4)

  }
}
