package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scodec.bits.ByteVector

final case class BigtableColumn(
    // [Required] Qualifier of the column. Columns in the parent column family that has this exact qualifier are exposed as . field. If the qualifier is valid UTF-8 string, it can be specified in the qualifier_string field. Otherwise, a base-64 encoded value must be set to qualifier_encoded. The column field name is the same as the column qualifier. However, if the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as field_name.
    qualifierEncoded: ByteVector,
    // [Optional] If this is set, only the latest version of value in this column are exposed. 'onlyReadLatest' can also be set at the column family level. However, the setting at this level takes precedence if 'onlyReadLatest' is set at both levels.
    onlyReadLatest: Option[Boolean] = None,
    // [Optional] The encoding of the values when the type is not STRING. Acceptable encoding values are: TEXT - indicates values are alphanumeric text strings. BINARY - indicates values are encoded using HBase Bytes.toBytes family of functions. 'encoding' can also be set at the column family level. However, the setting at this level takes precedence if 'encoding' is set at both levels.
    encoding: Option[String] = None,
    // [Optional] If the qualifier is not a valid BigQuery field identifier i.e. does not match [a-zA-Z][a-zA-Z0-9_]*, a valid identifier must be provided as the column field name and is used as field name in queries.
    fieldName: Option[String] = None,
    // [Optional] The type to convert the value in cells of this column. The values are expected to be encoded using HBase Bytes.toBytes function when using the BINARY encoding value. Following BigQuery types are allowed (case-sensitive) - BYTES STRING INTEGER FLOAT BOOLEAN Default type is BYTES. 'type' can also be set at the column family level. However, the setting at this level takes precedence if 'type' is set at both levels.
    `type`: Option[String] = None,
    qualifierString: Option[String] = None,
)
object BigtableColumn {
  implicit val encoder: Encoder[BigtableColumn] = Encoder.instance { x =>
    Json.obj(
      "qualifierEncoded" := x.qualifierEncoded,
      "onlyReadLatest" := x.onlyReadLatest,
      "encoding" := x.encoding,
      "fieldName" := x.fieldName,
      "type" := x.`type`,
      "qualifierString" := x.qualifierString,
    )
  }
  implicit val decoder: Decoder[BigtableColumn] = Decoder.instance { c =>
    for {
      v0 <- c.get[ByteVector]("qualifierEncoded")
      v1 <- c.get[Option[Boolean]]("onlyReadLatest")
      v2 <- c.get[Option[String]]("encoding")
      v3 <- c.get[Option[String]]("fieldName")
      v4 <- c.get[Option[String]]("type")
      v5 <- c.get[Option[String]]("qualifierString")
    } yield BigtableColumn(v0, v1, v2, v3, v4, v5)
  }
}
