package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class BigQueryModelTraining(
    // [Output-only, Beta] Index of current ML training iteration. Updated during create model query job to show job progress.
    currentIteration: Option[Int] = None,
    // [Output-only, Beta] Expected number of iterations for the create model query job specified as num_iterations in the input query. The actual total number of iterations may be less than this number due to early stop.
    expectedTotalIterations: Option[Long] = None,
)
object BigQueryModelTraining {
  implicit val encoder: Encoder[BigQueryModelTraining] = Encoder.instance { x =>
    Json.obj(
      "currentIteration" := x.currentIteration,
      "expectedTotalIterations" := x.expectedTotalIterations,
    )
  }
  implicit val decoder: Decoder[BigQueryModelTraining] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Int]]("currentIteration")
      v1 <- c.get[Option[Long]]("expectedTotalIterations")
    } yield BigQueryModelTraining(v0, v1)

  }
}
