package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class BigLakeConfiguration(
    // [Required] Required and immutable. Credential reference for accessing external storage system. Normalized as project_id.location_id.connection_id.
    connectionId: String,
    // [Required] Required and immutable. Open source file format that the table data is stored in. Currently only PARQUET is supported.
    fileFormat: String,
    // [Required] Required and immutable. Fully qualified location prefix of the external folder where data is stored. Normalized to standard format: "gs:////". Starts with "gs://" rather than "/bigstore/". Ends with "/". Does not contain "*". See also BigLakeStorageMetadata on how it is used.
    storageUri: String,
    // [Required] Required and immutable. Open source file format that the table data is stored in. Currently only PARQUET is supported.
    tableFormat: String,
)
object BigLakeConfiguration {
  implicit val encoder: Encoder[BigLakeConfiguration] = Encoder.instance { x =>
    Json.obj(
      "connectionId" := x.connectionId,
      "fileFormat" := x.fileFormat,
      "storageUri" := x.storageUri,
      "tableFormat" := x.tableFormat,
    )
  }
  implicit val decoder: Decoder[BigLakeConfiguration] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("connectionId")
      v1 <- c.get[String]("fileFormat")
      v2 <- c.get[String]("storageUri")
      v3 <- c.get[String]("tableFormat")
    } yield BigLakeConfiguration(v0, v1, v2, v3)

  }
}
