package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class BiEngineStatistics(
    // [Output-only] Specifies which mode of BI Engine acceleration was performed (if any).
    accelerationMode: Option[String] = None,
    // [Output-only] Specifies which mode of BI Engine acceleration was performed (if any).
    biEngineMode: Option[String] = None,
    // In case of DISABLED or PARTIAL bi_engine_mode, these contain the explanatory reasons as to why BI Engine could not accelerate. In case the full query was accelerated, this field is not populated.
    biEngineReasons: Option[List[BiEngineReason]] = None,
)
object BiEngineStatistics {
  implicit val encoder: Encoder[BiEngineStatistics] = Encoder.instance { x =>
    Json.obj(
      "accelerationMode" := x.accelerationMode,
      "biEngineMode" := x.biEngineMode,
      "biEngineReasons" := x.biEngineReasons,
    )
  }
  implicit val decoder: Decoder[BiEngineStatistics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("accelerationMode")
      v1 <- c.get[Option[String]]("biEngineMode")
      v2 <- c.get[Option[List[BiEngineReason]]]("biEngineReasons")
    } yield BiEngineStatistics(v0, v1, v2)

  }
}
