package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class BiEngineReason(
    // [Output-only] High-level BI Engine reason for partial or disabled acceleration.
    code: Option[String] = None,
    // [Output-only] Free form human-readable reason for partial or disabled acceleration.
    message: Option[String] = None,
)
object BiEngineReason {
  implicit val encoder: Encoder[BiEngineReason] = Encoder.instance { x =>
    Json.obj("code" := x.code, "message" := x.message)
  }
  implicit val decoder: Decoder[BiEngineReason] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("code")
      v1 <- c.get[Option[String]]("message")
    } yield BiEngineReason(v0, v1)
  }
}
