package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class AvroOptions(
    // [Optional] If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for example, INTEGER).
    useAvroLogicalTypes: Option[Boolean] = None
)
object AvroOptions {
  implicit val encoder: Encoder[AvroOptions] = Encoder.instance { x =>
    Json.obj("useAvroLogicalTypes" := x.useAvroLogicalTypes)
  }
  implicit val decoder: Decoder[AvroOptions] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Boolean]]("useAvroLogicalTypes")
    } yield AvroOptions(v0)
  }
}
