package googleapis.bigquery

import io.circe._

sealed abstract class AuditLogConfigLogType(val value: String) extends Product with Serializable
object AuditLogConfigLogType {
  // Default case. Should never be this.
  case object LOG_TYPE_UNSPECIFIED extends AuditLogConfigLogType("LOG_TYPE_UNSPECIFIED")
  // Admin reads. Example: CloudIAM getIamPolicy
  case object ADMIN_READ extends AuditLogConfigLogType("ADMIN_READ")
  // Data writes. Example: CloudSQL Users create
  case object DATA_WRITE extends AuditLogConfigLogType("DATA_WRITE")
  // Data reads. Example: CloudSQL Users list
  case object DATA_READ extends AuditLogConfigLogType("DATA_READ")
  val values = List(LOG_TYPE_UNSPECIFIED, ADMIN_READ, DATA_WRITE, DATA_READ)
  def fromString(input: String): Either[String, AuditLogConfigLogType] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for AuditLogConfigLogType")
  implicit val decoder: Decoder[AuditLogConfigLogType] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[AuditLogConfigLogType] = Encoder[String].contramap(_.value)
}
