package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class AuditLogConfig(
    // Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
    exemptedMembers: Option[List[String]] = None,
    // The log type that this config enables.
    logType: Option[AuditLogConfigLogType] = None,
)
object AuditLogConfig {
  implicit val encoder: Encoder[AuditLogConfig] = Encoder.instance { x =>
    Json.obj("exemptedMembers" := x.exemptedMembers, "logType" := x.logType)
  }
  implicit val decoder: Decoder[AuditLogConfig] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("exemptedMembers")
      v1 <- c.get[Option[AuditLogConfigLogType]]("logType")
    } yield AuditLogConfig(v0, v1)
  }
}
