package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class AuditConfig(
    // The configuration for logging of each type of permission.
    auditLogConfigs: Option[List[AuditLogConfig]] = None,
    // Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
    service: Option[String] = None,
)
object AuditConfig {
  implicit val encoder: Encoder[AuditConfig] = Encoder.instance { x =>
    Json.obj("auditLogConfigs" := x.auditLogConfigs, "service" := x.service)
  }
  implicit val decoder: Decoder[AuditConfig] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[AuditLogConfig]]]("auditLogConfigs")
      v1 <- c.get[Option[String]]("service")
    } yield AuditConfig(v0, v1)
  }
}
