package googleapis.bigquery

import io.circe._

sealed abstract class ArimaSingleModelForecastingMetricsSeasonalPeriod(val value: String)
    extends Product
    with Serializable
object ArimaSingleModelForecastingMetricsSeasonalPeriod {
  // Unspecified seasonal period.
  case object SEASONAL_PERIOD_TYPE_UNSPECIFIED
      extends ArimaSingleModelForecastingMetricsSeasonalPeriod("SEASONAL_PERIOD_TYPE_UNSPECIFIED")
  // No seasonality
  case object NO_SEASONALITY
      extends ArimaSingleModelForecastingMetricsSeasonalPeriod("NO_SEASONALITY")
  // Daily period, 24 hours.
  case object DAILY extends ArimaSingleModelForecastingMetricsSeasonalPeriod("DAILY")
  // Weekly period, 7 days.
  case object WEEKLY extends ArimaSingleModelForecastingMetricsSeasonalPeriod("WEEKLY")
  // Monthly period, 30 days or irregular.
  case object MONTHLY extends ArimaSingleModelForecastingMetricsSeasonalPeriod("MONTHLY")
  // Quarterly period, 90 days or irregular.
  case object QUARTERLY extends ArimaSingleModelForecastingMetricsSeasonalPeriod("QUARTERLY")
  // Yearly period, 365 days or irregular.
  case object YEARLY extends ArimaSingleModelForecastingMetricsSeasonalPeriod("YEARLY")
  val values = List(
    SEASONAL_PERIOD_TYPE_UNSPECIFIED,
    NO_SEASONALITY,
    DAILY,
    WEEKLY,
    MONTHLY,
    QUARTERLY,
    YEARLY,
  )
  def fromString(input: String): Either[String, ArimaSingleModelForecastingMetricsSeasonalPeriod] =
    values
      .find(_.value == input)
      .toRight(
        s"'$input' was not a valid value for ArimaSingleModelForecastingMetricsSeasonalPeriod"
      )
  implicit val decoder: Decoder[ArimaSingleModelForecastingMetricsSeasonalPeriod] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[ArimaSingleModelForecastingMetricsSeasonalPeriod] =
    Encoder[String].contramap(_.value)
}
