package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ArimaSingleModelForecastingMetrics(
    // Is arima model fitted with drift or not. It is always false when d is not 1.
    hasDrift: Option[Boolean] = None,
    // Seasonal periods. Repeated because multiple periods are supported for one time series.
    seasonalPeriods: Option[
      List[ArimaSingleModelForecastingMetricsSeasonalPeriod]
    ] = None, // Non-seasonal order.
    nonSeasonalOrder: Option[ArimaOrder] = None, // Arima fitting metrics.
    arimaFittingMetrics: Option[ArimaFittingMetrics] = None,
    // If true, spikes_and_dips is a part of time series decomposition result.
    hasSpikesAndDips: Option[Boolean] = None,
    // The tuple of time_series_ids identifying this time series. It will be one of the unique tuples of values present in the time_series_id_columns specified during ARIMA model training. Only present when time_series_id_columns training option was used and the order of values here are same as the order of time_series_id_columns.
    timeSeriesIds: Option[List[String]] = None,
    // If true, step_changes is a part of time series decomposition result.
    hasStepChanges: Option[Boolean] = None,
    // If true, holiday_effect is a part of time series decomposition result.
    hasHolidayEffect: Option[Boolean] = None,
    // The time_series_id value for this time series. It will be one of the unique values from the time_series_id_column specified during ARIMA model training. Only present when time_series_id_column training option was used.
    timeSeriesId: Option[String] = None,
)
object ArimaSingleModelForecastingMetrics {
  implicit val encoder: Encoder[
    ArimaSingleModelForecastingMetrics
  ] = Encoder.instance { x =>
    Json.obj(
      "hasDrift" := x.hasDrift,
      "seasonalPeriods" := x.seasonalPeriods,
      "nonSeasonalOrder" := x.nonSeasonalOrder,
      "arimaFittingMetrics" := x.arimaFittingMetrics,
      "hasSpikesAndDips" := x.hasSpikesAndDips,
      "timeSeriesIds" := x.timeSeriesIds,
      "hasStepChanges" := x.hasStepChanges,
      "hasHolidayEffect" := x.hasHolidayEffect,
      "timeSeriesId" := x.timeSeriesId,
    )
  }
  implicit val decoder: Decoder[
    ArimaSingleModelForecastingMetrics
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Boolean]]("hasDrift")
      v1 <- c.get[Option[List[ArimaSingleModelForecastingMetricsSeasonalPeriod]]]("seasonalPeriods")
      v2 <- c.get[Option[ArimaOrder]]("nonSeasonalOrder")
      v3 <- c.get[Option[ArimaFittingMetrics]]("arimaFittingMetrics")
      v4 <- c.get[Option[Boolean]]("hasSpikesAndDips")
      v5 <- c.get[Option[List[String]]]("timeSeriesIds")
      v6 <- c.get[Option[Boolean]]("hasStepChanges")
      v7 <- c.get[Option[Boolean]]("hasHolidayEffect")
      v8 <- c.get[Option[String]]("timeSeriesId")
    } yield ArimaSingleModelForecastingMetrics(v0, v1, v2, v3, v4, v5, v6, v7, v8)
  }
}
