package googleapis.bigquery

import io.circe._

sealed abstract class ArimaResultSeasonalPeriod(val value: String) extends Product with Serializable
object ArimaResultSeasonalPeriod {
  // Unspecified seasonal period.
  case object SEASONAL_PERIOD_TYPE_UNSPECIFIED
      extends ArimaResultSeasonalPeriod("SEASONAL_PERIOD_TYPE_UNSPECIFIED")
  // No seasonality
  case object NO_SEASONALITY extends ArimaResultSeasonalPeriod("NO_SEASONALITY")
  // Daily period, 24 hours.
  case object DAILY extends ArimaResultSeasonalPeriod("DAILY")
  // Weekly period, 7 days.
  case object WEEKLY extends ArimaResultSeasonalPeriod("WEEKLY")
  // Monthly period, 30 days or irregular.
  case object MONTHLY extends ArimaResultSeasonalPeriod("MONTHLY")
  // Quarterly period, 90 days or irregular.
  case object QUARTERLY extends ArimaResultSeasonalPeriod("QUARTERLY")
  // Yearly period, 365 days or irregular.
  case object YEARLY extends ArimaResultSeasonalPeriod("YEARLY")
  val values = List(
    SEASONAL_PERIOD_TYPE_UNSPECIFIED,
    NO_SEASONALITY,
    DAILY,
    WEEKLY,
    MONTHLY,
    QUARTERLY,
    YEARLY,
  )
  def fromString(input: String): Either[String, ArimaResultSeasonalPeriod] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for ArimaResultSeasonalPeriod")
  implicit val decoder: Decoder[ArimaResultSeasonalPeriod] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[ArimaResultSeasonalPeriod] = Encoder[String].contramap(_.value)
}
