package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ArimaResult(
    // This message is repeated because there are multiple arima models fitted in auto-arima. For non-auto-arima model, its size is one.
    arimaModelInfo: Option[List[ArimaModelInfo]] = None,
    // Seasonal periods. Repeated because multiple periods are supported for one time series.
    seasonalPeriods: Option[List[ArimaResultSeasonalPeriod]] = None,
)
object ArimaResult {
  implicit val encoder: Encoder[ArimaResult] = Encoder.instance { x =>
    Json.obj(
      "arimaModelInfo" := x.arimaModelInfo,
      "seasonalPeriods" := x.seasonalPeriods,
    )
  }
  implicit val decoder: Decoder[ArimaResult] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[ArimaModelInfo]]]("arimaModelInfo")
      v1 <- c.get[Option[List[ArimaResultSeasonalPeriod]]]("seasonalPeriods")
    } yield ArimaResult(v0, v1)
  }
}
