package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ArimaOrder( // Order of the differencing part.
    d: Option[Long] = None, // Order of the autoregressive part.
    p: Option[Long] = None, // Order of the moving-average part.
    q: Option[Long] = None,
)
object ArimaOrder {
  implicit val encoder: Encoder[ArimaOrder] = Encoder.instance { x =>
    Json.obj("d" := x.d, "p" := x.p, "q" := x.q)
  }
  implicit val decoder: Decoder[ArimaOrder] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Long]]("d")
      v1 <- c.get[Option[Long]]("p")
      v2 <- c.get[Option[Long]]("q")
    } yield ArimaOrder(v0, v1, v2)
  }
}
