package googleapis.bigquery

import io.circe._

sealed abstract class ArimaModelInfoSeasonalPeriod(val value: String)
    extends Product
    with Serializable
object ArimaModelInfoSeasonalPeriod {
  // Unspecified seasonal period.
  case object SEASONAL_PERIOD_TYPE_UNSPECIFIED
      extends ArimaModelInfoSeasonalPeriod("SEASONAL_PERIOD_TYPE_UNSPECIFIED")
  // No seasonality
  case object NO_SEASONALITY extends ArimaModelInfoSeasonalPeriod("NO_SEASONALITY")
  // Daily period, 24 hours.
  case object DAILY extends ArimaModelInfoSeasonalPeriod("DAILY")
  // Weekly period, 7 days.
  case object WEEKLY extends ArimaModelInfoSeasonalPeriod("WEEKLY")
  // Monthly period, 30 days or irregular.
  case object MONTHLY extends ArimaModelInfoSeasonalPeriod("MONTHLY")
  // Quarterly period, 90 days or irregular.
  case object QUARTERLY extends ArimaModelInfoSeasonalPeriod("QUARTERLY")
  // Yearly period, 365 days or irregular.
  case object YEARLY extends ArimaModelInfoSeasonalPeriod("YEARLY")
  val values = List(
    SEASONAL_PERIOD_TYPE_UNSPECIFIED,
    NO_SEASONALITY,
    DAILY,
    WEEKLY,
    MONTHLY,
    QUARTERLY,
    YEARLY,
  )
  def fromString(input: String): Either[String, ArimaModelInfoSeasonalPeriod] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for ArimaModelInfoSeasonalPeriod")
  implicit val decoder: Decoder[ArimaModelInfoSeasonalPeriod] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[ArimaModelInfoSeasonalPeriod] = Encoder[String].contramap(_.value)
}
