package googleapis.bigquery

import io.circe._

sealed abstract class ArimaForecastingMetricsSeasonalPeriod(val value: String)
    extends Product
    with Serializable
object ArimaForecastingMetricsSeasonalPeriod {
  // Unspecified seasonal period.
  case object SEASONAL_PERIOD_TYPE_UNSPECIFIED
      extends ArimaForecastingMetricsSeasonalPeriod("SEASONAL_PERIOD_TYPE_UNSPECIFIED")
  // No seasonality
  case object NO_SEASONALITY extends ArimaForecastingMetricsSeasonalPeriod("NO_SEASONALITY")
  // Daily period, 24 hours.
  case object DAILY extends ArimaForecastingMetricsSeasonalPeriod("DAILY")
  // Weekly period, 7 days.
  case object WEEKLY extends ArimaForecastingMetricsSeasonalPeriod("WEEKLY")
  // Monthly period, 30 days or irregular.
  case object MONTHLY extends ArimaForecastingMetricsSeasonalPeriod("MONTHLY")
  // Quarterly period, 90 days or irregular.
  case object QUARTERLY extends ArimaForecastingMetricsSeasonalPeriod("QUARTERLY")
  // Yearly period, 365 days or irregular.
  case object YEARLY extends ArimaForecastingMetricsSeasonalPeriod("YEARLY")
  val values = List(
    SEASONAL_PERIOD_TYPE_UNSPECIFIED,
    NO_SEASONALITY,
    DAILY,
    WEEKLY,
    MONTHLY,
    QUARTERLY,
    YEARLY,
  )
  def fromString(input: String): Either[String, ArimaForecastingMetricsSeasonalPeriod] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for ArimaForecastingMetricsSeasonalPeriod")
  implicit val decoder: Decoder[ArimaForecastingMetricsSeasonalPeriod] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[ArimaForecastingMetricsSeasonalPeriod] =
    Encoder[String].contramap(_.value)
}
