package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ArimaForecastingMetrics(
    // Whether Arima model fitted with drift or not. It is always false when d is not 1.
    hasDrift: Option[List[Boolean]] = None,
    // Seasonal periods. Repeated because multiple periods are supported for one time series.
    seasonalPeriods: Option[List[ArimaForecastingMetricsSeasonalPeriod]] = None,
    // Non-seasonal order.
    nonSeasonalOrder: Option[List[ArimaOrder]] = None,
    // Arima model fitting metrics.
    arimaFittingMetrics: Option[List[ArimaFittingMetrics]] = None,
    // Repeated as there can be many metric sets (one for each model) in auto-arima and the large-scale case.
    arimaSingleModelForecastingMetrics: Option[
      List[ArimaSingleModelForecastingMetrics]
    ] = None,
    // Id to differentiate different time series for the large-scale case.
    timeSeriesId: Option[List[String]] = None,
)
object ArimaForecastingMetrics {
  implicit val encoder: Encoder[
    ArimaForecastingMetrics
  ] = Encoder.instance { x =>
    Json.obj(
      "hasDrift" := x.hasDrift,
      "seasonalPeriods" := x.seasonalPeriods,
      "nonSeasonalOrder" := x.nonSeasonalOrder,
      "arimaFittingMetrics" := x.arimaFittingMetrics,
      "arimaSingleModelForecastingMetrics" := x.arimaSingleModelForecastingMetrics,
      "timeSeriesId" := x.timeSeriesId,
    )
  }
  implicit val decoder: Decoder[
    ArimaForecastingMetrics
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[Boolean]]]("hasDrift")
      v1 <- c.get[Option[List[ArimaForecastingMetricsSeasonalPeriod]]]("seasonalPeriods")
      v2 <- c.get[Option[List[ArimaOrder]]]("nonSeasonalOrder")
      v3 <- c.get[Option[List[ArimaFittingMetrics]]]("arimaFittingMetrics")
      v4 <- c.get[Option[List[ArimaSingleModelForecastingMetrics]]](
        "arimaSingleModelForecastingMetrics"
      )
      v5 <- c.get[Option[List[String]]]("timeSeriesId")
    } yield ArimaForecastingMetrics(v0, v1, v2, v3, v4, v5)
  }
}
