package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ArimaFittingMetrics( // AIC.
    aic: Option[Double] = None, // Log-likelihood.
    logLikelihood: Option[Double] = None, // Variance.
    variance: Option[Double] = None,
)
object ArimaFittingMetrics {
  implicit val encoder: Encoder[ArimaFittingMetrics] = Encoder.instance { x =>
    Json.obj(
      "aic" := x.aic,
      "logLikelihood" := x.logLikelihood,
      "variance" := x.variance,
    )
  }
  implicit val decoder: Decoder[ArimaFittingMetrics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Double]]("aic")
      v1 <- c.get[Option[Double]]("logLikelihood")
      v2 <- c.get[Option[Double]]("variance")
    } yield ArimaFittingMetrics(v0, v1, v2)

  }
}
