package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ArimaCoefficients(
    // Auto-regressive coefficients, an array of double.
    autoRegressiveCoefficients: Option[List[Double]] = None,
    // Intercept coefficient, just a double not an array.
    interceptCoefficient: Option[Double] = None,
    // Moving-average coefficients, an array of double.
    movingAverageCoefficients: Option[List[Double]] = None,
)
object ArimaCoefficients {
  implicit val encoder: Encoder[ArimaCoefficients] = Encoder.instance { x =>
    Json.obj(
      "autoRegressiveCoefficients" := x.autoRegressiveCoefficients,
      "interceptCoefficient" := x.interceptCoefficient,
      "movingAverageCoefficients" := x.movingAverageCoefficients,
    )
  }
  implicit val decoder: Decoder[ArimaCoefficients] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[Double]]]("autoRegressiveCoefficients")
      v1 <- c.get[Option[Double]]("interceptCoefficient")
      v2 <- c.get[Option[List[Double]]]("movingAverageCoefficients")
    } yield ArimaCoefficients(v0, v1, v2)

  }
}
