package googleapis.bigquery

import io.circe._

sealed abstract class ArgumentMode(val value: String) extends Product with Serializable
object ArgumentMode {
  // Default value.
  case object MODE_UNSPECIFIED extends ArgumentMode("MODE_UNSPECIFIED")
  // The argument is input-only.
  case object IN extends ArgumentMode("IN")
  // The argument is output-only.
  case object OUT extends ArgumentMode("OUT")
  // The argument is both an input and an output.
  case object INOUT extends ArgumentMode("INOUT")
  val values = List(MODE_UNSPECIFIED, IN, OUT, INOUT)
  def fromString(input: String): Either[String, ArgumentMode] =
    values.find(_.value == input).toRight(s"'$input' was not a valid value for ArgumentMode")
  implicit val decoder: Decoder[ArgumentMode] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[ArgumentMode] = Encoder[String].contramap(_.value)
}
