package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class Argument(
    // Optional. The name of this argument. Can be absent for function return argument.
    name: Option[String] = None,
    // Optional. Whether the argument is an aggregate function parameter. Must be Unset for routine types other than AGGREGATE_FUNCTION. For AGGREGATE_FUNCTION, if set to false, it is equivalent to adding "NOT AGGREGATE" clause in DDL; Otherwise, it is equivalent to omitting "NOT AGGREGATE" clause in DDL.
    isAggregate: Option[Boolean] = None,
    // Optional. Specifies whether the argument is input or output. Can be set for procedures only.
    mode: Option[ArgumentMode] = None,
    // Required unless argument_kind = ANY_TYPE.
    dataType: Option[StandardSqlDataType] = None,
    // Optional. Defaults to FIXED_TYPE.
    argumentKind: Option[ArgumentArgumentKind] = None,
)
object Argument {
  implicit val encoder: Encoder[Argument] = Encoder.instance { x =>
    Json.obj(
      "name" := x.name,
      "isAggregate" := x.isAggregate,
      "mode" := x.mode,
      "dataType" := x.dataType,
      "argumentKind" := x.argumentKind,
    )
  }
  implicit val decoder: Decoder[Argument] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("name")
      v1 <- c.get[Option[Boolean]]("isAggregate")
      v2 <- c.get[Option[ArgumentMode]]("mode")
      v3 <- c.get[Option[StandardSqlDataType]]("dataType")
      v4 <- c.get[Option[ArgumentArgumentKind]]("argumentKind")
    } yield Argument(v0, v1, v2, v3, v4)
  }
}
