package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class AggregationThresholdPolicy(
    // Optional. The privacy unit column(s) associated with this policy. For now, only one column per data source object (table, view) is allowed as a privacy unit column. Representing as a repeated field in metadata for extensibility to multiple columns in future. Duplicates and Repeated struct fields are not allowed. For nested fields, use dot notation ("outer.inner")
    privacyUnitColumns: Option[List[String]] = None,
    // Optional. The threshold for the "aggregation threshold" policy.
    threshold: Option[Long] = None,
)
object AggregationThresholdPolicy {
  implicit val encoder: Encoder[
    AggregationThresholdPolicy
  ] = Encoder.instance { x =>
    Json.obj(
      "privacyUnitColumns" := x.privacyUnitColumns,
      "threshold" := x.threshold,
    )
  }
  implicit val decoder: Decoder[
    AggregationThresholdPolicy
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("privacyUnitColumns")
      v1 <- c.get[Option[Long]]("threshold")
    } yield AggregationThresholdPolicy(v0, v1)
  }
}
