/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.yunpian;

import net.guerlab.sms.server.loadbalancer.SmsSenderLoadBalancer;
import net.guerlab.sms.server.spring.autoconfigure.SmsAutoConfiguration;
import net.guerlab.sms.yunpian.YunPianProperties;
import net.guerlab.sms.yunpian.YunPianSendHandler;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@EnableConfigurationProperties(value={YunPianProperties.class})
@AutoConfigureAfter(value={SmsAutoConfiguration.class})
public class YunPianAutoConfigure {
    @Bean
    @Conditional(value={YunPianSendHandlerCondition.class})
    @ConditionalOnBean(value={SmsSenderLoadBalancer.class})
    public YunPianSendHandler yunPianSendHandler(YunPianProperties properties, SmsSenderLoadBalancer loadbalancer, ApplicationEventPublisher eventPublisher) {
        YunPianSendHandler handler = new YunPianSendHandler(properties, eventPublisher);
        loadbalancer.addTarget((Object)handler, Boolean.valueOf(true));
        loadbalancer.setWeight((Object)handler, properties.getWeight());
        return handler;
    }

    public static class YunPianSendHandlerCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Boolean enable = (Boolean)context.getEnvironment().getProperty("sms.yunpian.enable", Boolean.class);
            return enable == null || enable != false;
        }
    }
}

