/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.yunpian;

import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.model.Result;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import net.guerlab.sms.yunpian.YunPianProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YunPianSendHandler
extends AbstractSendHandler<YunPianProperties> {
    private static final Logger log = LoggerFactory.getLogger(YunPianSendHandler.class);
    private final YunpianClient client;

    public YunPianSendHandler(YunPianProperties properties) {
        super((AbstractHandlerProperties)properties);
        this.client = new YunpianClient(properties.getApikey()).init();
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        String templateId = (String)((YunPianProperties)this.properties).getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            return false;
        }
        Map params = noticeData.getParams();
        StringBuilder paramsStringBuilder = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            boolean firstParam = true;
            for (Map.Entry entry : params.entrySet()) {
                if (!firstParam) {
                    paramsStringBuilder.append("&");
                }
                paramsStringBuilder.append(this.getEncodeValue("#" + (String)entry.getKey() + "#"));
                paramsStringBuilder.append("=");
                paramsStringBuilder.append(this.getEncodeValue((String)entry.getValue()));
                firstParam = false;
            }
        }
        String mobileString = StringUtils.join(phones, (String)",");
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put("apikey", ((YunPianProperties)this.properties).getApikey());
        data.put("mobile", mobileString);
        data.put("tpl_id", templateId);
        data.put("tpl_value", paramsStringBuilder.toString());
        Result result = phones.size() > 1 ? this.client.sms().tpl_batch_send(data) : this.client.sms().tpl_single_send(data);
        boolean succeed = Objects.equals(result.getCode(), 0);
        if (!succeed) {
            log.debug("send fail: {}", (Object)result.getMsg());
        }
        return succeed;
    }

    private String getEncodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

