/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.upyun;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.exception.SendFailedException;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import net.guerlab.sms.upyun.MessageId;
import net.guerlab.sms.upyun.UpyunProperties;
import net.guerlab.sms.upyun.UpyunSendRequest;
import net.guerlab.sms.upyun.UpyunSendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class UpyunSendHandler
extends AbstractSendHandler<UpyunProperties> {
    private static final Logger log = LoggerFactory.getLogger(UpyunSendHandler.class);
    private static final String API_URL = "https://sms-api.upyun.com/api/messages";
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate;

    public UpyunSendHandler(UpyunProperties properties, ApplicationEventPublisher eventPublisher, ObjectMapper objectMapper, RestTemplate restTemplate) {
        super((AbstractHandlerProperties)properties, eventPublisher);
        this.objectMapper = objectMapper;
        this.restTemplate = restTemplate;
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        String templateId = (String)((UpyunProperties)this.properties).getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException("templateId invalid"));
            return false;
        }
        ArrayList<String> params = this.buildParams(noticeData);
        UpyunSendRequest request = new UpyunSendRequest();
        request.setMobile(StringUtils.join(phones, (String)","));
        request.setTemplateId(templateId);
        request.setVars(StringUtils.join(params, (String)"|"));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Authorization", ((UpyunProperties)this.properties).getToken());
        try {
            boolean sendFail;
            HttpEntity httpEntity = new HttpEntity((Object)this.objectMapper.writeValueAsString((Object)request), (MultiValueMap)headers);
            ResponseEntity httpResponse = this.restTemplate.exchange(API_URL, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            if (httpResponse.getBody() == null) {
                log.debug("response body ie null");
                this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException("response body ie null"));
                return false;
            }
            String responseContent = (String)httpResponse.getBody();
            boolean isJson = responseContent.startsWith("{") && responseContent.endsWith("}");
            boolean bl = sendFail = !responseContent.contains("message_ids");
            if (!isJson || sendFail) {
                log.debug("send fail: {}", (Object)responseContent);
                this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException(responseContent));
                return false;
            }
            log.debug("responseContent: {}", (Object)responseContent);
            UpyunSendResult result = (UpyunSendResult)this.objectMapper.readValue(responseContent, UpyunSendResult.class);
            Collection<MessageId> messageIds = result.getMessageIds();
            if (messageIds == null || messageIds.isEmpty()) {
                this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException("empty messageIds list"));
                return false;
            }
            boolean succeed = messageIds.stream().filter(Objects::nonNull).anyMatch(MessageId::succeed);
            if (succeed) {
                this.publishSendSuccessEvent(noticeData, phones);
            } else {
                this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException("templateId invalid"));
            }
            return succeed;
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            this.publishSendFailEvent(noticeData, phones, e);
            return false;
        }
    }

    private ArrayList<String> buildParams(NoticeData noticeData) {
        List paramsOrder = ((UpyunProperties)this.properties).getParamsOrder(noticeData.getType());
        ArrayList<String> params = new ArrayList<String>();
        if (!paramsOrder.isEmpty()) {
            Map paramMap = noticeData.getParams();
            for (String paramName : paramsOrder) {
                String paramValue = (String)paramMap.get(paramName);
                params.add(paramValue);
            }
        }
        return params;
    }

    public String getChannelName() {
        return "upyun";
    }
}

