/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.upyun;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import net.guerlab.sms.upyun.MessageId;
import net.guerlab.sms.upyun.UpyunProperties;
import net.guerlab.sms.upyun.UpyunSendRequest;
import net.guerlab.sms.upyun.UpyunSendResult;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class UpyunSendHandler
extends AbstractSendHandler<UpyunProperties> {
    private static final Logger log = LoggerFactory.getLogger(UpyunSendHandler.class);
    private static final String API_URL = "https://sms-api.upyun.com/api/messages";
    private final ObjectMapper objectMapper;
    private final CloseableHttpClient client;

    public UpyunSendHandler(UpyunProperties properties, ApplicationEventPublisher eventPublisher, ObjectMapper objectMapper) {
        super((AbstractHandlerProperties)properties, eventPublisher);
        this.objectMapper = objectMapper;
        this.client = this.buildHttpclient();
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        String templateId = (String)((UpyunProperties)this.properties).getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            return false;
        }
        List paramsOrder = ((UpyunProperties)this.properties).getParamsOrder(type);
        ArrayList<String> params = new ArrayList<String>();
        if (!paramsOrder.isEmpty()) {
            Map paramMap = noticeData.getParams();
            for (String paramName : paramsOrder) {
                String paramValue = (String)paramMap.get(paramName);
                params.add(paramValue);
            }
        }
        UpyunSendRequest request = new UpyunSendRequest();
        request.setMobile(StringUtils.join(phones, (String)","));
        request.setTemplateId(templateId);
        request.setVars(StringUtils.join(params, (String)"|"));
        try {
            boolean sendFail;
            CloseableHttpResponse response = this.client.execute(RequestBuilder.post((String)API_URL).addHeader("Authorization", ((UpyunProperties)this.properties).getToken()).addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).setEntity((HttpEntity)new StringEntity(this.objectMapper.writeValueAsString((Object)request))).build());
            String responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            boolean isJson = responseContent.startsWith("{") && responseContent.endsWith("}");
            boolean bl = sendFail = !responseContent.contains("message_ids");
            if (!isJson || sendFail) {
                log.debug("send fail: {}", (Object)responseContent);
                return false;
            }
            log.debug("responseContent: {}", (Object)responseContent);
            UpyunSendResult result = (UpyunSendResult)this.objectMapper.readValue(responseContent, UpyunSendResult.class);
            Collection<MessageId> messageIds = result.getMessageIds();
            if (messageIds == null || messageIds.isEmpty()) {
                return false;
            }
            boolean succeed = messageIds.stream().filter(Objects::nonNull).anyMatch(MessageId::succeed);
            if (succeed) {
                this.publishSendEndEvent(noticeData, phones);
            }
            return succeed;
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    private CloseableHttpClient buildHttpclient() {
        try {
            TrustStrategy trustStrategy = (x509CertChain, authType) -> true;
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(trustStrategy).build();
            return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public String getChannelName() {
        return "upyun";
    }
}

