/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.template.support;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.template.support.NoticeTemplateAdapter;
import org.springframework.lang.Nullable;

public final class NoticeTemplate {
    public static final String DEFAULT_ADAPTER_ENV_NAME = "net.guerlab.sms.template.defaultAdapterKey";
    public static final String ADAPTER_KEY_LINK_CHARACTER = ":";
    private static final Map<String, NoticeTemplateAdapter> ADAPTER_MAP = new HashMap<String, NoticeTemplateAdapter>();
    private static String defaultAdapterKey = "SIMPLE";

    private NoticeTemplate() {
    }

    public static String getDefaultAdapterKey() {
        return defaultAdapterKey;
    }

    public static void setDefaultAdapterKey(@Nullable String adapterKey) {
        if (adapterKey != null && ADAPTER_MAP.containsKey(adapterKey)) {
            defaultAdapterKey = adapterKey;
        }
    }

    public static String format(String contentTemplate, NoticeData noticeData) {
        Map params = noticeData.getParams();
        if (StringUtils.isBlank((CharSequence)contentTemplate) || params == null || params.isEmpty()) {
            return "";
        }
        int adapterKeyIndex = contentTemplate.indexOf(ADAPTER_KEY_LINK_CHARACTER);
        NoticeTemplateAdapter templateAdapter = null;
        if (adapterKeyIndex > 0) {
            String adapterKey = contentTemplate.substring(0, adapterKeyIndex).toUpperCase();
            contentTemplate = contentTemplate.substring(adapterKeyIndex + 1);
            templateAdapter = ADAPTER_MAP.get(adapterKey);
        }
        if (templateAdapter == null) {
            String content = contentTemplate;
            templateAdapter = ADAPTER_MAP.values().stream().filter(adapter -> adapter.support(content)).findFirst().orElse(ADAPTER_MAP.get(defaultAdapterKey));
        }
        return templateAdapter != null ? templateAdapter.format(contentTemplate, params) : contentTemplate;
    }

    static {
        ServiceLoader<NoticeTemplateAdapter> serviceLoader = ServiceLoader.load(NoticeTemplateAdapter.class);
        serviceLoader.forEach(adapter -> ADAPTER_MAP.put(adapter.adapterKey().toUpperCase(), (NoticeTemplateAdapter)adapter));
        String defaultAdapterKey = System.getenv(DEFAULT_ADAPTER_ENV_NAME);
        NoticeTemplate.setDefaultAdapterKey(defaultAdapterKey);
    }
}

